/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class NewZealandReplaceRule
extends AbstractSimpleReplaceRule {
    public static final String NEW_ZEALAND_SIMPLE_REPLACE_RULE = "EN_NZ_SIMPLE_REPLACE";
    private static final Map<String, List<String>> wrongWords = NewZealandReplaceRule.loadFromPath("/en/en-NZ/replace.txt");
    private static final Locale EN_NZ_LOCALE = new Locale("en-NZ");

    @Override
    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public NewZealandReplaceRule(ResourceBundle messages) throws IOException {
        super(messages);
        this.setLocQualityIssueType(ITSIssueType.LocaleViolation);
        this.addExamplePair(Example.wrong("A <marker>sidewalk</marker> is a path along the side of a road."), Example.fixed("A <marker>footpath</marker> is a path along the side of a road."));
    }

    @Override
    public final String getId() {
        return NEW_ZEALAND_SIMPLE_REPLACE_RULE;
    }

    @Override
    public String getDescription() {
        return "English words easily confused in New Zealand English";
    }

    @Override
    public String getShort() {
        return "Not a New Zealand English word";
    }

    @Override
    public String getMessage(String tokenStr, List<String> replacements) {
        return tokenStr + " is a non-standard expression, in New Zealand English it is more common to use: " + String.join((CharSequence)", ", replacements) + ".";
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public Locale getLocale() {
        return EN_NZ_LOCALE;
    }
}

